/*
 * Decompiled with CFR 0.152.
 */
package climatecad;

import java.util.HashMap;
import java.util.Map;

public class transPos {
    int[] J = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    double[][] Gs = new double[9][12];
    double albedo = 0.15;

    private int getDOY(int dd, int mm) {
        int n = 0;
        if (mm > 1) {
            int i = 0;
            while (i < mm - 1) {
                n += this.J[mm];
                ++i;
            }
        }
        return n + dd;
    }

    private double getDEC(int doy) {
        double delta = doy > 173 ? 0.026 * Math.sin((double)((doy - 173) * 2) * Math.PI / 365.25) : 0.0;
        double dec = Math.asin(0.389 * Math.sin(((double)doy - 79.25) * 2.0 * Math.PI / 365.25)) + delta;
        return dec;
    }

    private Map getLCTS(double lat, double dec) {
        double ahs = 0.0;
        double lts = 0.0;
        double cts = 0.0;
        HashMap<String, Double> res = new HashMap<String, Double>(10);
        if (lat + dec < 1.5707963267948966 && lat - dec < 1.5707963267948966) {
            ahs = Math.acos(-Math.tan(lat) * Math.tan(dec));
            lts = 12.0 - ahs * 12.0 / Math.PI;
            cts = 12.0 + ahs * 12.0 / Math.PI;
        } else if (lat + dec >= 1.5707963267948966) {
            ahs = Math.PI;
            lts = 0.0;
            cts = 24.0;
        } else if (lat - dec >= 1.5707963267948966) {
            ahs = 0.0;
            lts = 12.0;
            cts = 12.0;
        }
        res.put("ahs", ahs);
        res.put("lts", lts);
        res.put("cts", cts);
        return res;
    }

    public double getHC(double lat, double hoy) {
        int doy = (int)Math.floor(hoy / 24.0);
        double dec = this.getDEC(doy);
        double hod = hoy - (double)(doy * 24);
        Map res = this.getHCAZ(lat, dec, hod);
        double hc = (Double)res.get("hc");
        return hc;
    }

    public double[] getHCAZ(double lat, double hoy) {
        int doy = (int)Math.floor(hoy / 24.0);
        double dec = this.getDEC(doy);
        double hod = hoy - (double)(doy * 24);
        Map res = this.getHCAZ(lat, dec, hod);
        double hc = (Double)res.get("hc");
        double az = (Double)res.get("az");
        double[] val = new double[]{hc, az};
        return val;
    }

    private Map getHCAZ(double lat, double dec, double hod) {
        double ah = 0.0;
        double Oz = 0.0;
        double hc = 0.0;
        double az = 0.0;
        double a1 = 0.0;
        HashMap<String, Double> res = new HashMap<String, Double>(10);
        ah = hod * Math.PI / 12.0 + Math.PI;
        Oz = Math.acos(Math.sin(lat) * Math.sin(dec) + Math.cos(lat) * Math.cos(dec) * Math.cos(ah));
        hc = 1.5707963267948966 - Oz;
        if (hc > 0.0) {
            a1 = Math.sin(lat) * Math.cos(ah) - Math.cos(lat) * Math.tan(dec);
            az = Math.atan(Math.sin(ah) / a1);
            if (a1 < 0.0) {
                az += Math.PI;
            }
            if ((az -= Math.PI) < 0.0) {
                az += Math.PI * 2;
            }
        }
        res.put("az", az);
        res.put("hc", hc);
        res.put("Oz", Oz);
        return res;
    }

    private double getHiPlan(double Oz, double az, double inc, double paz) {
        double hi = -1.0 * (Math.acos(Math.cos(inc) * Math.cos(Oz) + Math.sin(inc) * Math.sin(Oz) * Math.cos(az - paz)) - 1.5707963267948966);
        return hi;
    }

    public double[] getTransPosition(double lat, double alt, double paz, double inc, int jj) {
        double[] Gs = new double[12];
        double ahs = 0.0;
        double Oz = 0.0;
        Map res = new HashMap(10);
        int m = 0;
        while (m < 12) {
            double I0 = 1353.0 * (1.0 + 0.033 * Math.cos((double)(jj * 2) * Math.PI / 365.25));
            double dec = this.getDEC(jj);
            res = this.getLCTS(lat, dec);
            ahs = (Double)res.get("ahs");
            double lts = (Double)res.get("lts");
            double cts = (Double)res.get("cts");
            double Ho = 7.639437268410976 * I0 * Math.cos(lat) * Math.cos(dec) * (Math.sin(ahs) - ahs * Math.cos(ahs)) / 1000.0;
            double Hh = this.Gs[0][m] / 3.6;
            double Kh = Hh / (Ho * (double)this.J[m]);
            double Kd = Kh * (0.9 - 0.9 * Kh);
            double Hd = Kd * (Ho * (double)this.J[m]);
            double Hb = Hh - Hd;
            double SUM_Hbh = 0.0;
            double SUM_Hdh = 0.0;
            double SUM_Hbi = 0.0;
            double SUM_Hdi = 0.0;
            double hh = Math.ceil(lts);
            while (hh <= Math.floor(cts)) {
                double diri;
                double hih;
                double hi;
                double gloh;
                double difh;
                double dirh;
                double mair;
                res = this.getHCAZ(lat, dec, hh);
                double az = (Double)res.get("az");
                double hc = (Double)res.get("hc");
                Oz = (Double)res.get("Oz");
                if (hc > 0.0) {
                    mair = (1.0 - 0.1 * alt / 1000.0) / (Math.sin(hc) + 0.15 * Math.pow(hc + 3.885, -1.253));
                    dirh = I0 * Math.sin(hc) * Math.exp(-0.16 - 0.22 * mair);
                    difh = 160.0 * Math.pow(Math.sin(hc), 0.8) * (1.0 - 0.17 * (Math.sin(dec) / Math.sin(0.3987)));
                    gloh = dirh + difh;
                } else {
                    mair = 0.0;
                    dirh = 0.0;
                    difh = 0.0;
                    gloh = 0.0;
                }
                SUM_Hbh += dirh;
                SUM_Hdh += difh;
                if (hc > 0.0) {
                    double cfr_ignored_0 = I0 * Math.sin(hc);
                }
                if ((hi = this.getHiPlan(Oz, az, inc, paz)) > 0.0) {
                    hih = Math.sin(hi) / Math.sin(hc);
                    diri = dirh * hih;
                } else {
                    hih = 0.0;
                    diri = 0.0;
                    gloh = difh;
                }
                SUM_Hbi += diri;
                double refi = this.albedo * gloh * 0.5 * (1.0 - Math.cos(inc));
                double k = dirh / I0;
                double difi = difh * (k * hih + (1.0 - k) * 0.5 * (1.0 + Math.cos(inc))) + refi;
                SUM_Hdi += difi;
                hh += 1.0;
            }
            double Gbi = Hb * SUM_Hbi / SUM_Hbh;
            double Gdi = Hd * SUM_Hdi / SUM_Hdh;
            Gs[m] = (Gbi + Gdi) * 3.6;
            ++m;
        }
        return Gs;
    }

    private double radToDeg(double angleRad) {
        return 180.0 * angleRad / Math.PI;
    }

    private double degToRad(double angleDeg) {
        return Math.PI * angleDeg / 180.0;
    }

    private int calcJD(double year, double month, double day) {
        if (month <= 2.0) {
            year -= 1.0;
            month += 12.0;
        }
        double A = Math.floor(year / 100.0);
        double B = 2.0 - A + Math.floor(A / 4.0);
        double JD = Math.floor(365.25 * (year + 4716.0)) + Math.floor(30.6001 * (month + 1.0)) + day + B - 1524.5;
        return (int)JD;
    }

    private double calcTimeJulianCent(double JD) {
        double t = (JD - 2451545.0) / 36525.0;
        return t;
    }

    private double calcJDFromJulianCent(double t) {
        double JD = t * 36525.0 + 2451545.0;
        return JD;
    }

    private double calcGeomMeanLongSun(double t) {
        double l0 = 280.46646 + t * (36000.76983 + 3.032E-4 * t);
        while (l0 > 360.0 || l0 < 0.0) {
            if (l0 > 360.0) {
                l0 -= 360.0;
            }
            if (!(l0 < 0.0)) continue;
            l0 += 360.0;
        }
        return l0;
    }

    private double calcGeomMeanAnomalySun(double t) {
        double m = 357.52911 + t * (35999.05029 - 1.537E-4 * t);
        return m;
    }

    private double calcEccentricityEarthOrbit(double t) {
        double e = 0.016708634 - t * (4.2037E-5 + 1.267E-7 * t);
        return e;
    }

    private double calcSunEqOfCenter(double t) {
        double m = this.calcGeomMeanAnomalySun(t);
        double mrad = this.degToRad(m);
        double sinm = Math.sin(mrad);
        double sin2m = Math.sin(mrad + mrad);
        double sin3m = Math.sin(mrad + mrad + mrad);
        double c = sinm * (1.914602 - t * (0.004817 + 1.4E-5 * t)) + sin2m * (0.019993 - 1.01E-4 * t) + sin3m * 2.89E-4;
        return c;
    }

    private double calcSunTrueLong(double t) {
        double l0 = this.calcGeomMeanLongSun(t);
        double c = this.calcSunEqOfCenter(t);
        double O = l0 + c;
        return O;
    }

    private double calcSunTrueAnomaly(double t) {
        double m = this.calcGeomMeanAnomalySun(t);
        double c = this.calcSunEqOfCenter(t);
        double v = m + c;
        return v;
    }

    private double calcSunRadVector(double t) {
        double v = this.calcSunTrueAnomaly(t);
        double e = this.calcEccentricityEarthOrbit(t);
        double R = 1.000001018 * (1.0 - e * e) / (1.0 + e * Math.cos(this.degToRad(v)));
        return R;
    }

    private double calcSunApparentLong(double t) {
        double O = this.calcSunTrueLong(t);
        double omega = 125.04 - 1934.136 * t;
        double lambda = O - 0.00569 - 0.00478 * Math.sin(this.degToRad(omega));
        return lambda;
    }

    private double calcMeanObliquityOfEcliptic(double t) {
        double seconds = 21.448 - t * (46.815 + t * (5.9E-4 - t * 0.001813));
        double e0 = 23.0 + (26.0 + seconds / 60.0) / 60.0;
        return e0;
    }

    private double calcObliquityCorrection(double t) {
        double e0 = this.calcMeanObliquityOfEcliptic(t);
        double omega = 125.04 - 1934.136 * t;
        double e = e0 + 0.00256 * Math.cos(this.degToRad(omega));
        return e;
    }

    private double calcSunRtAscension(double t) {
        double e = this.calcObliquityCorrection(t);
        double lambda = this.calcSunApparentLong(t);
        double tananum = Math.cos(this.degToRad(e)) * Math.sin(this.degToRad(lambda));
        double tanadenom = Math.cos(this.degToRad(lambda));
        double alpha = this.radToDeg(Math.atan2(tananum, tanadenom));
        return alpha;
    }

    private double calcSunDeclination(double t) {
        double e = this.calcObliquityCorrection(t);
        double lambda = this.calcSunApparentLong(t);
        double sint = Math.sin(this.degToRad(e)) * Math.sin(this.degToRad(lambda));
        double theta = this.radToDeg(Math.asin(sint));
        return theta;
    }

    private double calcEquationOfTime(double t) {
        double epsilon = this.calcObliquityCorrection(t);
        double l0 = this.calcGeomMeanLongSun(t);
        double e = this.calcEccentricityEarthOrbit(t);
        double m = this.calcGeomMeanAnomalySun(t);
        double y = Math.tan(this.degToRad(epsilon) / 2.0);
        y = Math.pow(y, 2.0);
        double sin2l0 = Math.sin(2.0 * this.degToRad(l0));
        double sinm = Math.sin(this.degToRad(m));
        double cos2l0 = Math.cos(2.0 * this.degToRad(l0));
        double sin4l0 = Math.sin(4.0 * this.degToRad(l0));
        double sin2m = Math.sin(2.0 * this.degToRad(m));
        double Etime = y * sin2l0 - 2.0 * e * sinm + 4.0 * e * y * sinm * cos2l0 - 0.5 * y * y * sin4l0 - 1.25 * e * e * sin2m;
        return this.radToDeg(Etime) * 4.0;
    }

    private double calcHourAngleDawn(double lat, double solarDec, double solardepression) {
        double latRad = this.degToRad(lat);
        double sdRad = this.degToRad(solarDec);
        Math.cos(this.degToRad(90.0 + solardepression));
        Math.cos(latRad);
        Math.cos(sdRad);
        Math.tan(latRad);
        Math.tan(sdRad);
        double HA = Math.acos(Math.cos(this.degToRad(90.0 + solardepression)) / (Math.cos(latRad) * Math.cos(sdRad)) - Math.tan(latRad) * Math.tan(sdRad));
        return HA;
    }

    private double calcHourAngleSunrise(double lat, double solarDec) {
        double latRad = this.degToRad(lat);
        double sdRad = this.degToRad(solarDec);
        Math.cos(this.degToRad(90.833));
        Math.cos(latRad);
        Math.cos(sdRad);
        Math.tan(latRad);
        Math.tan(sdRad);
        double HA = Math.acos(Math.cos(this.degToRad(90.833)) / (Math.cos(latRad) * Math.cos(sdRad)) - Math.tan(latRad) * Math.tan(sdRad));
        return HA;
    }

    private double calcHourAngleSunset(double lat, double solarDec) {
        double latRad = this.degToRad(lat);
        double sdRad = this.degToRad(solarDec);
        Math.cos(this.degToRad(90.833));
        Math.cos(latRad);
        Math.cos(sdRad);
        Math.tan(latRad);
        Math.tan(sdRad);
        double HA = Math.acos(Math.cos(this.degToRad(90.833)) / (Math.cos(latRad) * Math.cos(sdRad)) - Math.tan(latRad) * Math.tan(sdRad));
        return -HA;
    }

    private double calcHourAngleDusk(double lat, double solarDec, double solardepression) {
        double latRad = this.degToRad(lat);
        double sdRad = this.degToRad(solarDec);
        Math.cos(this.degToRad(90.0 + solardepression));
        Math.cos(latRad);
        Math.cos(sdRad);
        Math.tan(latRad);
        Math.tan(sdRad);
        double HA = Math.acos(Math.cos(this.degToRad(90.0 + solardepression)) / (Math.cos(latRad) * Math.cos(sdRad)) - Math.tan(latRad) * Math.tan(sdRad));
        return -HA;
    }

    private double calcDawnUTC(double JD, double latitude, double longitude, double solardepression) {
        double t = this.calcTimeJulianCent(JD);
        double eqtime = this.calcEquationOfTime(t);
        double solarDec = this.calcSunDeclination(t);
        double hourangle = this.calcHourAngleSunrise(latitude, solarDec);
        double delta = longitude - this.radToDeg(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + timeUTC / 1440.0);
        eqtime = this.calcEquationOfTime(newt);
        solarDec = this.calcSunDeclination(newt);
        hourangle = this.calcHourAngleDawn(latitude, solarDec, solardepression);
        delta = longitude - this.radToDeg(hourangle);
        timeDiff = 4.0 * delta;
        timeUTC = 720.0 + timeDiff - eqtime;
        return timeUTC;
    }

    private double calcSunriseUTC(double JD, double latitude, double longitude) {
        double t = this.calcTimeJulianCent(JD);
        double eqtime = this.calcEquationOfTime(t);
        double solarDec = this.calcSunDeclination(t);
        double hourangle = this.calcHourAngleSunrise(latitude, solarDec);
        double delta = longitude - this.radToDeg(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + timeUTC / 1440.0);
        eqtime = this.calcEquationOfTime(newt);
        solarDec = this.calcSunDeclination(newt);
        hourangle = this.calcHourAngleSunrise(latitude, solarDec);
        delta = longitude - this.radToDeg(hourangle);
        timeDiff = 4.0 * delta;
        timeUTC = 720.0 + timeDiff - eqtime;
        return timeUTC;
    }

    private double calcSolNoonUTC(double t, double longitude) {
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + 0.5 + longitude / 360.0);
        double eqtime = this.calcEquationOfTime(newt);
        this.calcSunDeclination(newt);
        double solNoonUTC = 720.0 + longitude * 4.0 - eqtime;
        return solNoonUTC;
    }

    private double calcSunsetUTC(double JD, double latitude, double longitude) {
        double t = this.calcTimeJulianCent(JD);
        double eqtime = this.calcEquationOfTime(t);
        double solarDec = this.calcSunDeclination(t);
        double hourangle = this.calcHourAngleSunset(latitude, solarDec);
        double delta = longitude - this.radToDeg(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + timeUTC / 1440.0);
        eqtime = this.calcEquationOfTime(newt);
        solarDec = this.calcSunDeclination(newt);
        hourangle = this.calcHourAngleSunset(latitude, solarDec);
        delta = longitude - this.radToDeg(hourangle);
        timeDiff = 4.0 * delta;
        timeUTC = 720.0 + timeDiff - eqtime;
        return timeUTC;
    }

    private double calcDuskUTC(double JD, double latitude, double longitude, double solardepression) {
        double t = this.calcTimeJulianCent(JD);
        double eqtime = this.calcEquationOfTime(t);
        double solarDec = this.calcSunDeclination(t);
        double hourangle = this.calcHourAngleSunset(latitude, solarDec);
        double delta = longitude - this.radToDeg(hourangle);
        double timeDiff = 4.0 * delta;
        double timeUTC = 720.0 + timeDiff - eqtime;
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + timeUTC / 1440.0);
        eqtime = this.calcEquationOfTime(newt);
        solarDec = this.calcSunDeclination(newt);
        hourangle = this.calcHourAngleDusk(latitude, solarDec, solardepression);
        delta = longitude - this.radToDeg(hourangle);
        timeDiff = 4.0 * delta;
        timeUTC = 720.0 + timeDiff - eqtime;
        return timeUTC;
    }

    public double calcDawn(double lat, double lon, double year, double month, double day, double timezone, double dlstime, double solardepression) {
        double longitude = lon * -1.0;
        double latitude = lat;
        if (latitude > 89.8) {
            latitude = 89.8;
        }
        if (latitude < -89.8) {
            latitude = -89.8;
        }
        double JD = this.calcJD(year, month, day);
        double riseTimeGMT = this.calcDawnUTC(JD, latitude, longitude, solardepression);
        double riseTimeLST = riseTimeGMT + 60.0 * timezone + dlstime * 60.0;
        return riseTimeLST / 1440.0;
    }

    public double calcSunrise(double lat, double lon, double year, double month, double day, double timezone, double dlstime) {
        double longitude = lon * -1.0;
        double latitude = lat;
        if (latitude > 89.8) {
            latitude = 89.8;
        }
        if (latitude < -89.8) {
            latitude = -89.8;
        }
        double JD = this.calcJD(year, month, day);
        double riseTimeGMT = this.calcSunriseUTC(JD, latitude, longitude);
        double VriseTimeLST = riseTimeGMT + 60.0 * timezone + dlstime * 60.0;
        return VriseTimeLST / 1440.0;
    }

    public double calcSolarNoon(double lat, double lon, double year, double month, double day, double timezone, double dlstime) {
        double longitude = lon * -1.0;
        double latitude = lat;
        if (latitude > 89.8) {
            latitude = 89.8;
        }
        if (latitude < -89.8) {
            latitude = -89.8;
        }
        double JD = this.calcJD(year, month, day);
        double t = this.calcTimeJulianCent(JD);
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + 0.5 + longitude / 360.0);
        double eqtime = this.calcEquationOfTime(newt);
        this.calcSunDeclination(newt);
        double solNoonUTC = 720.0 + longitude * 4.0 - eqtime;
        double solarnoon = solNoonUTC + 60.0 * timezone + dlstime * 60.0;
        return solarnoon / 1440.0;
    }

    public double calcSunset(double lat, double lon, double year, double month, double day, double timezone, double dlstime) {
        double longitude = lon * -1.0;
        double latitude = lat;
        if (latitude > 89.8) {
            latitude = 89.8;
        }
        if (latitude < -89.8) {
            latitude = -89.8;
        }
        double JD = this.calcJD(year, month, day);
        double setTimeGMT = this.calcSunsetUTC(JD, latitude, longitude);
        double setTimeLST = setTimeGMT + 60.0 * timezone + dlstime * 60.0;
        return setTimeLST / 1440.0;
    }

    public double calcDusk(double lat, double lon, double year, double month, double day, double timezone, double dlstime, double solardepression) {
        double longitude = lon * -1.0;
        double latitude = lat;
        if (latitude > 89.8) {
            latitude = 89.8;
        }
        if (latitude < -89.8) {
            latitude = -89.8;
        }
        double JD = this.calcJD(year, month, day);
        double setTimeGMT = this.calcDuskUTC(JD, latitude, longitude, solardepression);
        double setTimeLST = setTimeGMT + 60.0 * timezone + dlstime * 60.0;
        return setTimeLST / 1440.0;
    }

    public double[] calcSunPosition(double lat, double lon, double year, double month, double day, double hours, double minutes, double seconds, double timezone, double dlstime) {
        double Etime;
        double longitude = lon * -1.0;
        double latitude = lat;
        if (latitude > 89.8) {
            latitude = 89.8;
        }
        if (latitude < -89.8) {
            latitude = -89.8;
        }
        double zone = timezone * -1.0;
        double daySavings = dlstime * 60.0;
        double hh = hours - daySavings / 60.0;
        double mm = minutes;
        double ss = seconds;
        double timenow = hh + mm / 60.0 + ss / 3600.0 + zone;
        double JD = this.calcJD(year, month, day);
        double t = this.calcTimeJulianCent(JD + timenow / 24.0);
        double R = this.calcSunRadVector(t);
        this.calcSunRtAscension(t);
        double theta = this.calcSunDeclination(t);
        double eqtime = Etime = this.calcEquationOfTime(t);
        double solarDec = theta;
        double solarTimeFix = eqtime - 4.0 * longitude + 60.0 * zone;
        double trueSolarTime = hh * 60.0 + mm + ss / 60.0 + solarTimeFix;
        while (trueSolarTime > 1440.0) {
            trueSolarTime -= 1440.0;
        }
        double hourangle = trueSolarTime / 4.0 - 180.0;
        if (hourangle < -180.0) {
            hourangle += 360.0;
        }
        double harad = this.degToRad(hourangle);
        double csZ = Math.sin(this.degToRad(latitude)) * Math.sin(this.degToRad(solarDec)) + Math.cos(this.degToRad(latitude)) * Math.cos(this.degToRad(solarDec)) * Math.cos(harad);
        if (csZ > 1.0) {
            csZ = 1.0;
        } else if (csZ < -1.0) {
            csZ = -1.0;
        }
        double zenith = this.radToDeg(Math.acos(csZ));
        double azDenom = Math.cos(this.degToRad(latitude)) * Math.sin(this.degToRad(zenith));
        double azimuth = 0.0;
        if (Math.abs(azDenom) > 0.001) {
            double azRad = (Math.sin(this.degToRad(latitude)) * Math.cos(this.degToRad(zenith)) - Math.sin(this.degToRad(solarDec))) / azDenom;
            if (Math.abs(azRad) > 1.0) {
                azRad = azRad < 0.0 ? -1.0 : 1.0;
            }
            azimuth = 180.0 - this.radToDeg(Math.acos(azRad));
            if (hourangle > 0.0) {
                azimuth = -azimuth;
            }
        } else {
            azimuth = latitude > 0.0 ? 180.0 : 0.0;
        }
        if (azimuth < 0.0) {
            azimuth += 360.0;
        }
        double exoatmElevation = 90.0 - zenith;
        double refractionCorrection = 0.0;
        if (exoatmElevation > 85.0) {
            refractionCorrection = 0.0;
        } else {
            double te = Math.tan(this.degToRad(exoatmElevation));
            if (exoatmElevation > 5.0) {
                refractionCorrection = 58.1 / te - 0.07 / (te * te * te) + 8.6E-5 / (te * te * te * te * te);
            } else if (exoatmElevation > -0.575) {
                double step1 = -12.79 + exoatmElevation * 0.711;
                double step2 = 103.4 + exoatmElevation * step1;
                double step3 = -518.2 + exoatmElevation * step2;
                refractionCorrection = 1735.0 + exoatmElevation * step3;
            } else {
                refractionCorrection = -20.774 / te;
            }
            refractionCorrection /= 3600.0;
        }
        double solarzen = zenith - refractionCorrection;
        double solarazimuth = azimuth;
        double solarelevation = 90.0 - solarzen;
        double[] result = new double[]{solarazimuth, solarelevation};
        return result;
    }
}

